************************************************************************************************
* Name			: table A1 - baseline characteristics by treatment status 
*
* Description	: This dofile performs balancing tests  
************************************************************************************************

********************************************************************************
* SETTINGS 
********************************************************************************
clear 				all 
set more 			off 
set graphics 		off 
version 			15          /*Use Stata 15*/ 
set seed			16072015   	/* This is the seed number that was used to create the bootstrapped samples for estimation of the model in the paper */ 

* Options for data to create 
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 			/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

* Globals of directories, variable groups and others 
run "$dir_statacode\globals.do" 

* Dataset with standardized measures 
use "$dir_data\measures.dta", clear 


******************************************************** 
* TESTS 
********************************************************

cap log close 
log using "$dir_output/TableA1.log", replace

su $balance_child $balance_mother $balance_hh if treat == 1 

su $balance_child $balance_mother $balance_hh if treat==2 

foreach group in balance_child balance_mother balance_hh { 

di "************************************************************" 
di "* T-TESTS FOR `group' * " 
di "************************************************************" 
	foreach var in $`group'{ 
	di "* `var' * " 
	ttest `var', by(treat)
	} 
	
} 
 
* Romano wolf pvalues 
di "************************************************************" 
di "* ROMANO WOLF * " 
di "************************************************************" 
rwolf $balance_child $balance_mother $balance_hh,  indepvar(treat) cluster(cod_dane) reps(250)

log close 




